---
Difficulty: Hard  
Source: Daily-Question(POTD 25-Nov)  
Tags:  
  - Array  
  - Breadth-First Search  
  - Matrix
---

# 🚀 *773 - Sliding Puzzle* 🧠

### Problem Link:  
[**LeetCode - Sliding Puzzle**](https://leetcode.com/problems/sliding-puzzle/description/?envType=daily-question&envId=2024-11-25)

## 💡 **Problem Breakdown:**

You are given a 2x3 board with five tiles labeled from 1 to 5, and an empty square represented by 0. A move consists of selecting the 0 and a number adjacent to it (up, down, left, or right), swapping their positions.

The goal is to reach the solved state: `[[1, 2, 3], [4, 5, 0]]`.

Return the least number of moves required to solve the puzzle. If it's impossible to solve, return -1.

## 🔍 **Example Walkthrough:**

### Example 1:
<img src="https://github.com/user-attachments/assets/642d7fb9-9d69-4b67-9b64-b40771e23548" width="35%">

**Input:**  
`board = [[1, 2, 3], [4, 0, 5]]`  
**Output:**  
`1`

**Explanation:**  
Swap the `0` and `5` in one move.

### Example 2:
<img src="https://github.com/user-attachments/assets/7b4f6ee8-4f37-40c5-b8b6-d53a54d03f63" width="35%">

**Input:**  
`board = [[1, 2, 3], [5, 4, 0]]`  
**Output:**  
`-1`

**Explanation:**  
No number of moves will make the board solved.

### Example 3:
<img src="https://github.com/user-attachments/assets/bc9f2bc3-640a-4bee-9e79-14fb226f8679" width="35%">

**Input:**  
`board = [[4, 1, 2], [5, 0, 3]]`  
**Output:**  
`5`

**Explanation:**  
The smallest number of moves to solve the board is 5. An example path:
- After move 0: `[[4, 1, 2], [5, 0, 3]]`
- After move 1: `[[4, 1, 2], [0, 5, 3]]`
- After move 2: `[[0, 1, 2], [4, 5, 3]]`
- After move 3: `[[1, 0, 2], [4, 5, 3]]`
- After move 4: `[[1, 2, 0], [4, 5, 3]]`
- After move 5: `[[1, 2, 3], [4, 5, 0]]`

### Constraints:
- `board.length == 2`
- `board[i].length == 3`
- `0 <= board[i][j] <= 5`
- Each value `board[i][j]` is unique.

## 🎯 **My Approach:**

1. **State Representation:**
   - Represent the board as a string to simplify comparisons between different states.
   
2. **BFS Approach:**
   - Perform a Breadth-First Search (BFS) to explore all possible moves from the current state, aiming to find the shortest path to the solved state.
   - Use a queue to explore each state along with the number of moves taken.
   
3. **Tracking Visited States:**
   - Use a set to keep track of the states that have already been visited to avoid cycles.
   
4. **Goal Check:**
   - The target goal state is `"123450"`, and we return the number of moves when we reach this state.

## 🕒 **Time Complexity:**
- **O(1):** Since the board is of fixed size (2x3), the number of possible states is constant, making the BFS run in constant time.

## 📝 **Solution Code**


## Code (C)

```c
#define QUEUE_SIZE 720

typedef struct {
    char state[7];
    int steps;
} Node;

int slidingPuzzle(int** board, int boardSize, int* boardColSize) {
    const int dirs[4][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
    const char* goal = "123450";
    char start[7] = {0};
    char seen[QUEUE_SIZE][7] = {0}; 
    Node queue[QUEUE_SIZE];
    int front = 0, rear = 0;

    for (int i = 0; i < boardSize; ++i)
        for (int j = 0; j < boardColSize[i]; ++j)
            start[i * boardColSize[i] + j] = '0' + board[i][j];

    if (strcmp(start, goal) == 0)
        return 0;

    strcpy(queue[rear].state, start);
    queue[rear++].steps = 0;
    strcpy(seen[rear - 1], start);

    while (front < rear) {
        Node curr = queue[front++];
        char state[7];
        strcpy(state, curr.state);
        int steps = curr.steps;
        int zeroIndex = strchr(state, '0') - state;
        int i = zeroIndex / 3;
        int j = zeroIndex % 3;

        for (int d = 0; d < 4; ++d) {
            int x = i + dirs[d][0];
            int y = j + dirs[d][1];
            if (x < 0 || x >= boardSize || y < 0 || y >= 3)
                continue;

            int swapIndex = x * 3 + y;
            char nextState[7];
            strcpy(nextState, state);
            char temp = nextState[zeroIndex];
            nextState[zeroIndex] = nextState[swapIndex];
            nextState[swapIndex] = temp;

            if (strcmp(nextState, goal) == 0)
                return steps + 1;

            bool alreadySeen = false;
            for (int k = 0; k < rear; ++k) {
                if (strcmp(seen[k], nextState) == 0) {
                    alreadySeen = true;
                    break;
                }
            }
            if (!alreadySeen) {
                strcpy(queue[rear].state, nextState);
                queue[rear++].steps = steps + 1;
                strcpy(seen[rear - 1], nextState);
            }
        }
    }

    return -1;
}
```

## Code (C++)

```cpp
class Solution {
 public:
  int slidingPuzzle(vector<vector<int>>& board) {
    constexpr int dirs[4][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
    constexpr int m = 2;
    constexpr int n = 3;
    const char* goal = "123450"; 
    string start;

    for (const auto& row : board)
      for (int num : row)
        start += '0' + num;

    if (start == goal)
      return 0;

    queue<pair<string, int>> q; 
    unordered_set<string> seen{start}; 
    q.emplace(start, 0);

    while (!q.empty()) {
      auto [state, steps] = q.front();
      q.pop();

      const int zeroIndex = state.find('0');
      const int i = zeroIndex / n;
      const int j = zeroIndex % n;

      for (const auto& [dx, dy] : dirs) {
        const int x = i + dx;
        const int y = j + dy;

        if (x < 0 || x >= m || y < 0 || y >= n)
          continue;

        const int swappedIndex = x * n + y;
        string nextState = state;
        swap(nextState[zeroIndex], nextState[swappedIndex]);

        if (nextState == goal)
          return steps + 1;

        if (seen.insert(nextState).second)
          q.emplace(nextState, steps + 1);
      }
    }

    return -1; 
  }
};
```

## Code (Java)

```java
class Solution {
    public int slidingPuzzle(int[][] board) {

        int[][] dirs = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
        String goal = "123450";
        StringBuilder start = new StringBuilder();

        for (int[] row : board) {
            for (int num : row) {
                start.append(num);
            }
        }

        if (start.toString().equals(goal)) {
            return 0;
        }

        Queue<String> queue = new ArrayDeque<>();
        Set<String> seen = new HashSet<>();
        queue.offer(start.toString());
        seen.add(start.toString());
        int steps = 0;

        while (!queue.isEmpty()) {
            int size = queue.size();

            for (int i = 0; i < size; i++) {
                String

 current = queue.poll();
                int zeroIndex = current.indexOf('0');
                int x = zeroIndex / 3;
                int y = zeroIndex % 3;

                for (int[] dir : dirs) {
                    int newX = x + dir[0];
                    int newY = y + dir[1];

                    if (newX < 0 || newX >= 2 || newY < 0 || newY >= 3) continue;

                    int newZeroIndex = newX * 3 + newY;
                    char[] nextState = current.toCharArray();
                    nextState[zeroIndex] = nextState[newZeroIndex];
                    nextState[newZeroIndex] = '0';
                    String nextStateStr = new String(nextState);

                    if (nextStateStr.equals(goal)) {
                        return steps + 1;
                    }

                    if (!seen.contains(nextStateStr)) {
                        queue.offer(nextStateStr);
                        seen.add(nextStateStr);
                    }
                }
            }
            steps++;
        }
        return -1;
    }
}
```

## Code (Python)

```python3
from collections import deque

class Solution:
    def slidingPuzzle(self, board: list[list[int]]) -> int:
        dirs = [(0, 1), (1, 0), (0, -1), (-1, 0)]
        goal = "123450"
        start = ''.join(str(board[i][j]) for i in range(2) for j in range(3))

        if start == goal:
            return 0

        queue = deque([(start, 0)])
        seen = {start}

        while queue:
            state, steps = queue.popleft()
            zero_index = state.index('0')
            x, y = divmod(zero_index, 3)

            for dx, dy in dirs:
                nx, ny = x + dx, y + dy
                if 0 <= nx < 2 and 0 <= ny < 3:
                    next_state = list(state)
                    next_state[zero_index], next_state[nx * 3 + ny] = next_state[nx * 3 + ny], next_state[zero_index]
                    next_state = ''.join(next_state)
                    if next_state == goal:
                        return steps + 1
                    if next_state not in seen:
                        queue.append((next_state, steps + 1))
                        seen.add(next_state)
        return -1
```

## Code (Rust)

```rust
use std::collections::{HashSet, VecDeque};

impl Solution {
    pub fn sliding_puzzle(board: Vec<Vec<i32>>) -> i32 {
        let dirs = [(0, 1), (1, 0), (0, -1), (-1, 0)];
        let goal = "123450";
        let mut start = String::new();

        for row in &board {
            for &num in row {
                start.push((num as u8 + b'0') as char);
            }
        }

        if start == goal {
            return 0;
        }

        let mut queue = VecDeque::new();
        let mut seen = HashSet::new();
        queue.push_back((start.clone(), 0));
        seen.insert(start.clone());

        while let Some((state, steps)) = queue.pop_front() {
            let zero_idx = state.find('0').unwrap();
            let x = zero_idx / 3;
            let y = zero_idx % 3;

            for &(dx, dy) in &dirs {
                let nx = x as i32 + dx;
                let ny = y as i32 + dy;

                if nx < 0 || nx >= 2 || ny < 0 || ny >= 3 {
                    continue;
                }

                let swap_idx = (nx * 3 + ny) as usize;

                let mut next_state: Vec<char> = state.chars().collect();
                next_state.swap(zero_idx, swap_idx);

                let next_state: String = next_state.into_iter().collect();

                if next_state == goal {
                    return steps + 1;
                }

                if seen.insert(next_state.clone()) {
                    queue.push_back((next_state, steps + 1));
                }
            }
        }

        -1
    }
}
```

# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).


## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:25px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
